/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.AbstractStructure;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketMetadata;
import com.comphenix.protocol.injector.StructureCache;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.ObjectWriter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.cloning.AggregateCloner;
import com.comphenix.protocol.reflect.cloning.BukkitCloner;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.reflect.cloning.CollectionCloner;
import com.comphenix.protocol.reflect.cloning.FieldCloner;
import com.comphenix.protocol.reflect.cloning.GuavaOptionalCloner;
import com.comphenix.protocol.reflect.cloning.ImmutableDetector;
import com.comphenix.protocol.reflect.cloning.JavaOptionalCloner;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.reflect.instances.MinecraftGenerator;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.Converters;
import com.comphenix.protocol.wrappers.WrappedStreamCodec;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class PacketContainer
extends AbstractStructure
implements Serializable {
    private static final long serialVersionUID = 3L;
    private PacketType type;
    private static final Map<PacketType, java.util.function.Function<Object, Object>> PACKET_DESERIALIZER_METHODS = new ConcurrentHashMap<PacketType, java.util.function.Function<Object, Object>>();
    private static final AggregateCloner DEEP_CLONER = AggregateCloner.newBuilder().instanceProvider(StructureCache::newInstance).andThen(BukkitCloner.class).andThen(ImmutableDetector.class).andThen(JavaOptionalCloner.class).andThen(GuavaOptionalCloner.class).andThen(CollectionCloner.class).andThen(PacketContainer.getSpecializedDeepClonerFactory()).build();
    private static final AggregateCloner SHALLOW_CLONER = AggregateCloner.newBuilder().instanceProvider(StructureCache::newInstance).andThen((Function<AggregateCloner.BuilderParameters, Cloner>)((Function)param -> {
        if (param == null) {
            throw new IllegalArgumentException("Cannot be NULL.");
        }
        return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
            {
                this.writer = new ObjectWriter();
            }
        };
    })).build();
    private static final Set<PacketType> FAST_CLONE_UNSUPPORTED = Sets.newHashSet((Object[])new PacketType[]{PacketType.Play.Server.BOSS, PacketType.Play.Server.ADVANCEMENTS, PacketType.Play.Client.USE_ENTITY, PacketType.Status.Server.SERVER_INFO});

    public PacketContainer(PacketType type) {
        this(type, StructureCache.newPacket(type));
    }

    public PacketContainer(PacketType type, Object handle) {
        this(type, handle, StructureCache.getStructure(type).withTarget(handle));
    }

    public PacketContainer(PacketType type, Object handle, StructureModifier<Object> structure) {
        super(handle, structure);
        this.type = type;
        this.setDefaults();
    }

    private void setDefaults() {
        if (MinecraftVersion.NETHER_UPDATE.atOrAbove() && this.type == PacketType.Play.Server.CHAT && !this.getUUIDs().optionRead(0).isPresent()) {
            this.getUUIDs().writeSafely(0, MinecraftGenerator.SYS_UUID);
        }
    }

    public static PacketContainer fromPacket(Object packet) {
        PacketType type = PacketType.fromClass(packet.getClass());
        return new PacketContainer(type, packet);
    }

    protected PacketContainer() {
    }

    @Override
    public Object getHandle() {
        return this.handle;
    }

    @Override
    public StructureModifier<Object> getModifier() {
        return this.structureModifier;
    }

    public StructureModifier<InternalStructure> getStructures() {
        return this.structureModifier.withType(Object.class, InternalStructure.CONVERTER);
    }

    public StructureModifier<Optional<InternalStructure>> getOptionalStructures() {
        return this.structureModifier.withType(Optional.class, Converters.optional(InternalStructure.CONVERTER));
    }

    @Deprecated
    public int getId() {
        return this.type.getCurrentId();
    }

    public PacketType getType() {
        return this.type;
    }

    public PacketContainer shallowClone() {
        Object clonedPacket = SHALLOW_CLONER.clone(this.getHandle());
        return new PacketContainer(this.getType(), clonedPacket);
    }

    public PacketContainer deepClone() {
        Object handle = this.getHandle();
        PacketType packetType = this.getType();
        if (handle == null || packetType == null) {
            return this;
        }
        if (!FAST_CLONE_UNSUPPORTED.contains(packetType)) {
            try {
                Object cloned = DEEP_CLONER.clone(handle);
                return new PacketContainer(packetType, cloned);
            }
            catch (Exception ex) {
                FAST_CLONE_UNSUPPORTED.add(packetType);
            }
        }
        Object serialized = this.serializeToBuffer();
        Object deserialized = PacketContainer.deserializeFromBuffer(packetType, serialized);
        ReferenceCountUtil.safeRelease((Object)serialized);
        return new PacketContainer(packetType, deserialized);
    }

    private static Function<AggregateCloner.BuilderParameters, Cloner> getSpecializedDeepClonerFactory() {
        return new Function<AggregateCloner.BuilderParameters, Cloner>(){

            public Cloner apply(@Nullable AggregateCloner.BuilderParameters param) {
                return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
                    {
                        super(defaultCloner, instanceProvider);
                        this.writer = new ObjectWriter(){

                            @Override
                            protected void transformField(StructureModifier<Object> modifierSource, StructureModifier<Object> modifierDest, int fieldIndex) {
                                if (modifierSource.getField(fieldIndex).getName().startsWith("inflatedBuffer")) {
                                    modifierDest.write(fieldIndex, modifierSource.read(fieldIndex));
                                } else {
                                    this.defaultTransform(modifierSource, modifierDest, this.getDefaultCloner(), fieldIndex);
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        ByteBuf buffer = (ByteBuf)this.serializeToBuffer();
        if (buffer != null) {
            output.writeBoolean(true);
            output.writeInt(buffer.readableBytes());
            buffer.readBytes((OutputStream)output, buffer.readableBytes());
            ReferenceCountUtil.safeRelease((Object)buffer);
        } else {
            output.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.structureModifier = StructureCache.getStructure(this.type);
        if (input.readBoolean()) {
            int transferredBytes;
            int dataLength = input.readInt();
            ByteBuf byteBuf = (ByteBuf)MinecraftReflection.createPacketDataSerializer(dataLength);
            while ((dataLength -= (transferredBytes = byteBuf.writeBytes((InputStream)input, dataLength))) > 0 && transferredBytes > 0) {
            }
            Object packet = PacketContainer.deserializeFromBuffer(this.type, byteBuf);
            ReferenceCountUtil.safeRelease((Object)byteBuf);
            this.handle = packet;
            this.structureModifier = this.structureModifier.withTarget(packet);
        }
    }

    @Deprecated
    public static ByteBuf createPacketBuffer() {
        return (ByteBuf)MinecraftReflection.createPacketDataSerializer(0);
    }

    public static Object deserializeFromBuffer(PacketType packetType, Object buffer) {
        if (buffer == null) {
            return null;
        }
        java.util.function.Function deserializer = PACKET_DESERIALIZER_METHODS.computeIfAbsent(packetType, type -> {
            WrappedStreamCodec streamCodec = PacketRegistry.getStreamCodec(type.getPacketClass());
            if (streamCodec != null) {
                return streamCodec::decode;
            }
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                ConstructorAccessor bufferConstructor = Accessors.getConstructorAccessorOrNull(type.getPacketClass(), MinecraftReflection.getPacketDataSerializerClass());
                if (bufferConstructor != null) {
                    return xva$0 -> bufferConstructor.invoke(xva$0);
                }
                List<Method> methods = FuzzyReflection.fromClass(type.getPacketClass(), true).getMethodList(FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(type.getPacketClass()).parameterExactArray(MinecraftReflection.getPacketDataSerializerClass()).build());
                if (!methods.isEmpty()) {
                    MethodAccessor accessor = Accessors.getMethodAccessor(methods.get(0));
                    return buf -> accessor.invoke(null, buf);
                }
            }
            MethodAccessor readMethod = MinecraftMethods.getPacketReadByteBufMethod();
            Objects.requireNonNull(readMethod, "Unable to find the Packet#read(ByteBuf) method, cannot deserialize " + String.valueOf(type));
            Object checkInstance = DefaultInstances.DEFAULT.create(type.getPacketClass());
            Objects.requireNonNull(checkInstance, "Unable to construct empty packet, cannot deserialize " + String.valueOf(type));
            return buf -> {
                Object packet = DefaultInstances.DEFAULT.create(type.getPacketClass());
                readMethod.invoke(packet, buf);
                return packet;
            };
        });
        return deserializer.apply(buffer);
    }

    public Object serializeToBuffer() {
        Object handle = this.getHandle();
        if (handle == null) {
            return null;
        }
        Object targetBuffer = MinecraftReflection.createPacketDataSerializer(0);
        WrappedStreamCodec streamCodec = PacketRegistry.getStreamCodec(this.type.getPacketClass());
        if (streamCodec != null) {
            streamCodec.encode(targetBuffer, handle);
        } else {
            MinecraftMethods.getPacketWriteByteBufMethod().invoke(handle, targetBuffer);
        }
        return targetBuffer;
    }

    public <T> Optional<T> getMeta(String key) {
        return PacketMetadata.get(this.handle, key);
    }

    public <T> void setMeta(String key, T value) {
        PacketMetadata.set(this.handle, key, value);
    }

    public void removeMeta(String key) {
        PacketMetadata.remove(this.handle, key);
    }

    private Method getMethodLazily(ConcurrentMap<Class<?>, Method> lookup, Class<?> handleClass, String methodName, Class<?> parameterClass) {
        Method initialized;
        Method method = (Method)lookup.get(handleClass);
        if (method == null && (method = lookup.putIfAbsent(handleClass, initialized = FuzzyReflection.fromClass(handleClass).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(parameterClass).returnTypeVoid().build()))) == null) {
            method = initialized;
        }
        return method;
    }

    public String toString() {
        return "PacketContainer[type=" + String.valueOf(this.type) + ", structureModifier=" + String.valueOf(this.structureModifier) + "]";
    }
}

